#!/bin/bash

#Validation Function:
#- Checks if the password is not empty.
#- Ensures the password length is between 5 and 16 characters.
#- Ensures the password is not the same as the username.
#- Checks if the password contains no spaces.
#- Ensures the password contains at least one uppercase letter.
#- Ensures the password contains at least one number.
#- Ensures the password contains at least one special character.

#Input and Validation:
#- Prompts the user to enter a username and password.
#- Calls the validation function to check the entered password.
#- Displays appropriate messages based on the validation result.

# Function to validate the password
function validate_password() {
    local password="$1"
    local username="$2"
    
    # Check if password is not empty
    if [[ -z "$password" ]]; then
        echo "Password cannot be empty."
        return 1
    fi

    # Check if password length is between 5 and 16 characters
    if [[ ${#password} -lt 5 ]] || [[ ${#password} -gt 16 ]]; then
        echo "Password must be between 5 and 16 characters long."
        return 1
    fi

    # Check if password is the same as the username
    if [[ "$password" == "$username" ]]; then
        echo "Password cannot be the same as the username."
        return 1
    fi

    # Check if password contains spaces
    if [[ "$password" =~ \  ]]; then
        echo "Password cannot contain spaces."
        return 1
    fi

    # Check if password contains at least one uppercase letter
    if ! [[ "$password" =~ [A-Z] ]]; then
        echo "Password must contain at least one uppercase letter."
        return 1
    fi

    # Check if password contains at least one number
    if ! [[ "$password" =~ [0-9] ]]; then
        echo "Password must contain at least one number."
        return 1
    fi

    # Check if password contains at least one special character
    if ! [[ "$password" =~ [^a-zA-Z0-9] ]]; then
        echo "Password must contain at least one special character."
        return 1
    fi
    
    return 0
}

# Get username and password input from the user
read -p "Enter username: " username
read -s -p "Enter password: " password
echo

# Validate the password
if validate_password "$password" "$username"; then
    echo "Password is valid."
else
    echo "Password is invalid. Please try again."
fi
