#!/bin/bash

#Email Format Validation:
#- Uses a regular expression to check if the email address format is valid.

#Domain Existence Check:
#- Uses the dig command to look up the domain's DNS records.
#- Ensures the domain has a valid DNS record.

#Input and Validation:
#- Prompts the user to enter an email address.
#- Extracts the domain from the email address.
#- Validates the email format and checks if the domain exists.
#- Displays appropriate messages based on the validation and check results.

# Function to validate the email format
function validate_email_format() {
    local email="$1"
    
    if [[ "$email" =~ ^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$ ]]; then
        return 0
    else
        echo "Invalid email format."
        return 1
    fi
}

# Function to check if the email domain exists
function check_domain_exists() {
    local domain="$1"
    
    if dig +short "$domain" | grep -q '^[0-9]'; then
        return 0
    else
        echo "Domain does not exist."
        return 1
    fi
}

# Get email input from the user
read -p "Enter email: " email

# Extract domain from email
domain=$(echo "$email" | awk -F '@' '{print $2}')

# Validate email format and check domain existence
if validate_email_format "$email"; then
    if check_domain_exists "$domain"; then
        echo "Email is valid and domain exists."
    else
        echo "Email is valid, but domain does not exist."
    fi
else
    echo "Invalid email format. Please try again."
fi
