#!/bin/bash

#Validation Function:
#- Checks if the username is not empty and has at least 5 characters.
#- Checks if the username contains only letters and numbers with no spaces.
#- Checks if the username already exists on the system.

#Input and Validation:
#- Prompts the user to enter a username.
#- Calls the validation function to check the entered username.
#- Displays appropriate messages based on the validation result.

# Function to validate the username
function validate_username() {
    local username="$1"
    
    # Check if username is not empty and has at least 5 characters
    if [[ -z "$username" ]] || [[ ${#username} -lt 5 ]]; then
        echo "Username must be at least 5 characters long and cannot be empty."
        return 1
    fi
    
    # Check if username contains only letters and numbers
    if ! [[ "$username" =~ ^[a-zA-Z0-9]+$ ]]; then
        echo "Username can only contain letters and numbers, and no spaces."
        return 1
    fi
    
    # Check if the username already exists on the system
    if id "$username" &>/dev/null; then
        echo "Username already exists on the system."
        return 1
    fi
    
    return 0
}

# Get username input from the user
read -p "Enter username: " username

# Validate the username
if validate_username "$username"; then
    echo "Username is valid."
else
    echo "Username is invalid. Please try again."
fi
